require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);
SetGamePause(true);

kResultShop = 0;
kResultGame = 1;

function Expert( display )
    t = {};
    if ( display == 1 ) then
        table.insert(t, Bitmap
            {
                name="expert",
                image="ui/levelover/expert",
                x=kCenter+170,
                y=kCenter-120,
            });
    end;
    return Group(t);
end;

function TextExpert( display )
    t = {};
    if ( display == 1 ) then
        table.insert(t, 
                Text
                {
					font = { FontGame, 28, YellowColor },
                    x = 462, y = 122,
                    w = 200, h = 200,
                    flags = kHAlignCenter + kVAlignCenter,
                    rotation = -11,
                    label="expert_badge",
                });
    end;
    return Group(t);
end;

function TextExpertShadow( display )
    t = {};
    if ( display == 1 ) then
        table.insert(t, 
                Text
                {
					font = { FontGame, 28, BlackColor },
                    x = 464, y = 124,
                    w = 200, h = 200,
                    flags = kHAlignCenter + kVAlignCenter,
                    rotation = -11,
                    label="expert_badge",
                });
    end;
    return Group(t);
end;


MakeDialog
{
    CDPanelWin
    {
        name="panelwin",
        x = 0,
        y = 0,
        w = 800,
        h = 600,
        
        enter_curve = "config/curves/fx_start.xml",
        exit_curve = "config/curves/fx_end.xml",
        
        Bitmap
        {
            x=kCenter,y=kCenter-1000,
            w=800,h=600,
            name="panel",
            alpha = 1,
        
            Bitmap
            {
                name="infopanel",
                image="ui/levelover/levelover",
                x=kCenter,
                y=kCenter,
                
		-- win caption
		SetStyle(CreateTextStyle(FontGame, 30, RedColor)),
		CreateText(kCenter-85,kCenter-230,"caption_win",0,0),
                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                -- number of served tables:
                CreateTextLeftAlign(kCenter+65,kCenter+30,"#"..GetString("tables_served",GetCustomersServedStr()),0,0),
                -- number of lost tables:
                CreateTextLeftAlign(kCenter+65,kCenter+50,"#"..GetString("tables_lost",GetCustomersLostStr()),0,0),

                

                SetStyle(CreateTextStyle(FontGame, 18, BlackColor)),
                Text
                {-- text for winning the level
                    x=100,
                    y=125,
                    w=250,--kMax-80,
                    h=kMax,
                    flags=kHAlignLeft+kVAlignTop,
                    label=GetString("story_win",GetCurrLevelNumStr()),
                },
                
                SetStyle(CreateTextStyle(FontGame, 26, RedColor)),
                Text
                {-- text "score:"
                    x=kCenter+65,y=kCenter+90,
                    flags=kHAlignLeft+kVAlignCenter,
                    label="levelscore",
                },
                
                SetStyle(CreateTextStyle(FontGame, 26, RedColor)),
                Text
                {-- score value
                    x=kCenter+130,y=kCenter+90,
                    flags=kHAlignLeft+kVAlignCenter,
                    label=GetLevelScore(),
                },

                SetStyle(CreateTextStyle(FontGame, 22, BlackColor)),
                Text
                {-- text "Total:"
                    x=kCenter+65,y=kCenter+120,
                    flags=kHAlignLeft+kVAlignCenter,
                    label="totalscore",
                },
                
                SetStyle(CreateTextStyle(FontGame, 22, BlackColor)),
                Text
                {-- total score value
                    x=kCenter+130,y=kCenter+120,
                    flags=kHAlignLeft+kVAlignCenter,
                    label=GetHighScore(),
                },
                
                SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
                Button
                {
                    x=kCenter-15,
                    y=kCenter + 185,
                    name="continue",
                    default = true,
                    command=
                        function()
                            HideWinPanel();
                        end,
				    SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
				    CreateText(2,2,"continue", 0, 0),
				    SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
				    CreateText(0,0,"continue", 0, 0),
                },
            },
            
            Bitmap
            {-- picture with happy flo
                name="win",
                image="ui/levelover/flo_win",
                x=kCenter-250,
                y=kCenter+26,
            },
            Expert( GetExpertAchieved() ),
            TextExpertShadow( GetExpertAchieved() ),
            TextExpert( GetExpertAchieved() ),
        },
    },
}